/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;

public final class RequestProcessor
implements Executor {
    private static RequestProcessor DEFAULT = new RequestProcessor();
    private static RequestProcessor UNLIMITED = new RequestProcessor("Default RequestProcessor", 50);
    private static final Timer starterThread = new Timer(true);
    private static Logger logger;
    private static int counter;
    private static final boolean SLOW;
    String name;
    boolean stopped = false;
    private final Object processorLock = new Object();
    private HashSet<Processor> processors = new HashSet();
    private List<Item> queue = new LinkedList<Item>();
    private int running = 0;
    private int throughput;
    private boolean interruptThread;

    public RequestProcessor() {
        this(null, 1);
    }

    public RequestProcessor(String string) {
        this(string, 1);
    }

    public RequestProcessor(String string, int n) {
        this(string, n, false);
    }

    public RequestProcessor(String string, int n, boolean bl) {
        this.throughput = n;
        this.name = string != null ? string : "OpenIDE-request-processor-" + counter++;
        this.interruptThread = bl;
    }

    public static RequestProcessor getDefault() {
        return UNLIMITED;
    }

    public void execute(Runnable runnable) {
        this.post(runnable);
    }

    public Task post(Runnable runnable) {
        return this.post(runnable, 0, 1);
    }

    public Task post(Runnable runnable, int n) {
        return this.post(runnable, n, 1);
    }

    public Task post(Runnable runnable, int n, int n2) {
        Task task = new Task(runnable, n2);
        task.schedule(n);
        return task;
    }

    public Task create(Runnable runnable) {
        return this.create(runnable, false);
    }

    public Task create(Runnable runnable, boolean bl) {
        Task task = new Task(runnable);
        if (bl) {
            task.notifyFinished();
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRequestProcessorThread() {
        Thread thread = Thread.currentThread();
        Object object = this.processorLock;
        synchronized (object) {
            return thread instanceof Processor && this.processors.contains((Processor)thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this == UNLIMITED || this == DEFAULT) {
            throw new IllegalArgumentException("Can't stop shared RP's");
        }
        Object object = this.processorLock;
        synchronized (object) {
            this.stopped = true;
            for (Processor processor : this.processors) {
                processor.interrupt();
            }
        }
    }

    @Deprecated
    public static Task postRequest(Runnable runnable) {
        return DEFAULT.post(runnable);
    }

    @Deprecated
    public static Task postRequest(Runnable runnable, int n) {
        return DEFAULT.post(runnable, n);
    }

    @Deprecated
    public static Task postRequest(Runnable runnable, int n, int n2) {
        return DEFAULT.post(runnable, n, n2);
    }

    @Deprecated
    public static Task createRequest(Runnable runnable) {
        return DEFAULT.create(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Logger logger() {
        Timer timer = starterThread;
        synchronized (timer) {
            if (logger == null) {
                logger = Logger.getLogger("org.openide.util.RequestProcessor");
            }
            return logger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueue(Item item) {
        Logger logger = RequestProcessor.logger();
        boolean bl = logger.isLoggable(Level.FINE);
        Object object = this.processorLock;
        synchronized (object) {
            if (item.getTask() == null) {
                if (bl) {
                    logger.fine("Null task for item " + item);
                }
                return;
            }
            this.prioritizedEnqueue(item);
            if (this.running < this.throughput) {
                ++this.running;
                Processor processor = Processor.get();
                this.processors.add(processor);
                processor.setName(this.name);
                processor.attachTo(this);
            }
        }
        if (bl) {
            logger.fine("Item enqueued: " + item.action + " status: " + item.enqueued);
        }
    }

    private void prioritizedEnqueue(Item item) {
        int n = item.getPriority();
        if (this.queue.isEmpty()) {
            this.queue.add(item);
            item.enqueued = true;
            return;
        }
        if (n > this.queue.get(this.queue.size() - 1).getPriority()) {
            ListIterator<Item> listIterator = this.queue.listIterator();
            while (listIterator.hasNext()) {
                Item item2 = listIterator.next();
                if (n <= item2.getPriority()) continue;
                listIterator.set(item);
                listIterator.add(item2);
                item.enqueued = true;
                return;
            }
            throw new IllegalStateException("Prioritized enqueue failed!");
        }
        this.queue.add(item);
        item.enqueued = true;
    }

    Task askForWork(Processor processor, String string) {
        if (this.stopped || this.queue.isEmpty()) {
            this.processors.remove(processor);
            Processor.put(processor, string);
            --this.running;
            return null;
        }
        Item item = this.queue.remove(0);
        Task task = item.getTask();
        item.clear(processor);
        return task;
    }

    static {
        counter = 0;
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        SLOW = bl;
    }

    private class EnqueueTask
    extends TimerTask {
        Item itm;

        EnqueueTask(Item item) {
            this.itm = item;
        }

        public void run() {
            try {
                RequestProcessor.this.enqueue(this.itm);
            }
            catch (RuntimeException runtimeException) {
                Exceptions.printStackTrace(runtimeException);
            }
        }
    }

    private static class Item
    extends Exception {
        private final RequestProcessor owner;
        private Object action;
        private boolean enqueued;
        String message;

        Item(Task task, RequestProcessor requestProcessor) {
            this.action = task;
            this.owner = requestProcessor;
        }

        Task getTask() {
            Object object = this.action;
            return object instanceof Task ? (Task)object : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean clear(Processor processor) {
            Object object = this.owner.processorLock;
            synchronized (object) {
                this.action = processor;
                return this.enqueued ? this.owner.queue.remove(this) : true;
            }
        }

        Processor getProcessor() {
            Object object = this.action;
            return object instanceof Processor ? (Processor)object : null;
        }

        int getPriority() {
            return this.getTask().getPriority();
        }

        public Throwable fillInStackTrace() {
            if (SLOW) {
                Throwable throwable = super.fillInStackTrace();
                StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                for (int i = 1; i < stackTraceElementArray.length; ++i) {
                    if (stackTraceElementArray[i].getClassName().startsWith("java.lang") || stackTraceElementArray[i].getClassName().startsWith(RequestProcessor.class.getName())) continue;
                    throwable.setStackTrace(Arrays.asList(stackTraceElementArray).subList(i - 1, stackTraceElementArray.length).toArray(new StackTraceElement[0]));
                    break;
                }
                return throwable;
            }
            return this;
        }

        public String getMessage() {
            return this.message;
        }
    }

    private static class Processor
    extends Thread {
        private static final Stack<Processor> pool = new Stack();
        private static final int INACTIVE_TIMEOUT = 60000;
        private RequestProcessor source;
        private Task todo;
        private boolean idle = true;
        private final Object lock = new Object();

        public Processor() {
            super(Processor.getTopLevelThreadGroup(), "Inactive RequestProcessor thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Processor get() {
            Stack<Processor> stack = pool;
            synchronized (stack) {
                if (pool.isEmpty()) {
                    Processor processor = new Processor();
                    processor.idle = false;
                    processor.start();
                    return processor;
                }
                Processor processor = pool.pop();
                processor.idle = false;
                return processor;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void put(Processor processor, String string) {
            Stack<Processor> stack = pool;
            synchronized (stack) {
                processor.setName("Inactive RequestProcessor thread [Was:" + processor.getName() + "/" + string + "]");
                processor.idle = true;
                pool.push(processor);
            }
        }

        void setPrio(int n) {
            if (n != this.getPriority()) {
                this.setPriority(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void attachTo(RequestProcessor requestProcessor) {
            Object object = this.lock;
            synchronized (object) {
                this.source = requestProcessor;
                this.lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object object;
                RequestProcessor requestProcessor = null;
                Object object2 = this.lock;
                synchronized (object2) {
                    try {
                        if (this.source == null) {
                            this.lock.wait(60000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    requestProcessor = this.source;
                    this.source = null;
                    if (requestProcessor == null) {
                        object = pool;
                        synchronized (object) {
                            if (this.idle) {
                                pool.remove(this);
                                break;
                            }
                            continue;
                        }
                    }
                }
                object2 = null;
                object = RequestProcessor.logger();
                boolean bl = ((Logger)object).isLoggable(Level.FINE);
                if (bl) {
                    ((Logger)object).fine("Begining work " + this.getName());
                }
                while (true) {
                    Object object3 = requestProcessor.processorLock;
                    synchronized (object3) {
                        this.todo = requestProcessor.askForWork(this, (String)object2);
                        if (this.todo == null) {
                            break;
                        }
                    }
                    this.setPrio(this.todo.getPriority());
                    try {
                        if (bl) {
                            ((Logger)object).fine("  Executing " + this.todo);
                        }
                        this.todo.run();
                        if (bl) {
                            ((Logger)object).fine("  Execution finished in" + this.getName());
                        }
                        object2 = this.todo.debug();
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        ((Logger)object).log(Level.SEVERE, null, outOfMemoryError);
                    }
                    catch (StackOverflowError stackOverflowError) {
                        Processor.doNotify(this.todo, stackOverflowError);
                    }
                    catch (Throwable throwable) {
                        Processor.doNotify(this.todo, throwable);
                    }
                    object3 = requestProcessor.processorLock;
                    synchronized (object3) {
                        this.todo = null;
                        Thread.interrupted();
                    }
                }
                if (!bl) continue;
                ((Logger)object).fine("Work finished " + this.getName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void doEvaluate(Task task, Object object, RequestProcessor requestProcessor) {
            Task task2 = this.todo;
            boolean bl = Thread.interrupted();
            try {
                this.todo = task;
                task.run();
            }
            finally {
                Object object2 = object;
                synchronized (object2) {
                    this.todo = task2;
                    if ((bl || this.todo.item == null) && requestProcessor.interruptThread) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        public void interruptTask(Task task, RequestProcessor requestProcessor) {
            if (task != this.todo) {
                return;
            }
            if (requestProcessor.interruptThread) {
                this.interrupt();
            }
        }

        private static void doNotify(Task task, Throwable throwable) {
            if (SLOW && ((Task)task).item.message == null) {
                ((Task)task).item.message = "task failed due to: " + throwable;
                task.item.initCause(throwable);
                throwable = task.item;
            }
            RequestProcessor.logger().log(Level.SEVERE, "Error in RequestProcessor " + task.debug(), throwable);
        }

        static ThreadGroup getTopLevelThreadGroup() {
            PrivilegedAction<ThreadGroup> privilegedAction = new PrivilegedAction<ThreadGroup>(){

                @Override
                public ThreadGroup run() {
                    ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                    while (threadGroup.getParent() != null) {
                        threadGroup = threadGroup.getParent();
                    }
                    return threadGroup;
                }
            };
            return AccessController.doPrivileged(privilegedAction);
        }
    }

    public final class Task
    extends org.openide.util.Task
    implements Cancellable {
        private Item item;
        private int priority;
        private long time;
        private Thread lastThread;

        Task(Runnable runnable) {
            super(runnable);
            this.priority = 1;
            this.time = 0L;
            this.lastThread = null;
        }

        Task(Runnable runnable, int n) {
            super(runnable);
            this.priority = 1;
            this.time = 0L;
            this.lastThread = null;
            if (n < 1) {
                n = 1;
            }
            if (n > 10) {
                n = 10;
            }
            this.priority = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.notifyRunning();
                this.lastThread = Thread.currentThread();
                this.run.run();
            }
            finally {
                Item item = this.item;
                if (item == null || item.getTask() != this) {
                    this.notifyFinished();
                }
                this.lastThread = null;
            }
        }

        public int getDelay() {
            long l = this.time - System.currentTimeMillis();
            if (l < 0L) {
                return 0;
            }
            if (l > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void schedule(int n) {
            Item item;
            if (RequestProcessor.this.stopped) {
                throw new IllegalStateException("RequestProcessor already stopped!");
            }
            this.time = System.currentTimeMillis() + (long)n;
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                this.notifyRunning();
                if (this.item != null) {
                    this.item.clear(null);
                }
                item = this.item = new Item(this, RequestProcessor.this);
            }
            if (n == 0) {
                RequestProcessor.this.enqueue(item);
            } else {
                starterThread.schedule((TimerTask)new EnqueueTask(item), n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel() {
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                boolean bl;
                if (this.item == null) {
                    bl = false;
                } else {
                    Processor processor = this.item.getProcessor();
                    bl = this.item.clear(null);
                    if (processor != null) {
                        processor.interruptTask(this, RequestProcessor.this);
                        this.item = null;
                    }
                }
                if (bl) {
                    this.notifyFinished();
                }
                return bl;
            }
        }

        public int getPriority() {
            return this.priority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPriority(int n) {
            if (this.priority == n) {
                return;
            }
            if (n < 1) {
                n = 1;
            }
            if (n > 10) {
                n = 10;
            }
            this.priority = n;
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                if (this.item == null) {
                    return;
                }
                if (RequestProcessor.this.queue.remove(this.item)) {
                    RequestProcessor.this.prioritizedEnqueue(this.item);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitFinished() {
            if (RequestProcessor.this.isRequestProcessorThread()) {
                boolean bl;
                boolean bl2;
                Logger logger = RequestProcessor.logger();
                boolean bl3 = logger.isLoggable(Level.FINE);
                if (bl3) {
                    logger.fine("Task.waitFinished on " + this + " from other task in RP: " + Thread.currentThread().getName());
                }
                Object object = RequestProcessor.this.processorLock;
                synchronized (object) {
                    bl2 = !this.isFinished();
                    boolean bl4 = bl = bl2 && (this.item == null || this.item.clear(null));
                    if (bl3) {
                        logger.fine("    ## finished: " + this.isFinished());
                        logger.fine("    ## item: " + this.item);
                    }
                }
                if (bl) {
                    if (bl3) {
                        logger.fine("    ## running it synchronously");
                    }
                    object = (Processor)Thread.currentThread();
                    ((Processor)object).doEvaluate(this, RequestProcessor.this.processorLock, RequestProcessor.this);
                } else {
                    if (bl3) {
                        logger.fine("    ## not running it synchronously");
                    }
                    if (bl2 && this.lastThread != Thread.currentThread()) {
                        if (bl3) {
                            logger.fine("    ## waiting for it to be finished: " + this.lastThread + " now: " + Thread.currentThread());
                        }
                        super.waitFinished();
                    }
                }
                if (bl3) {
                    logger.fine("    ## exiting waitFinished");
                }
            } else {
                super.waitFinished();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitFinished(long l) throws InterruptedException {
            if (RequestProcessor.this.isRequestProcessorThread()) {
                boolean bl;
                Object object = RequestProcessor.this.processorLock;
                synchronized (object) {
                    bl = !this.isFinished() && (this.item == null || this.item.clear(null));
                }
                if (bl) {
                    throw new InterruptedException("Cannot wait with timeout " + l + " from the RequestProcessor thread for task: " + this);
                }
                if (this.lastThread != Thread.currentThread()) {
                    return super.waitFinished(l);
                }
                return true;
            }
            return super.waitFinished(l);
        }

        public String toString() {
            return "RequestProcessor.Task [" + RequestProcessor.this.name + ", " + this.priority + "] for " + super.toString();
        }
    }
}

